/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.computer;

import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.report.computer.AbstractReportComputer;
import cz.insophy.inplan.report.result.WorkplaceUsageResult;
import cz.insophy.inplan.report.result.WorkplaceUsageTableRow;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkplaceUsageComputer
extends AbstractReportComputer<WorkplaceUsageResult> {
    private static final double COST_TIME_UNIT = 3600000.0;
    private static final String COST_PRODUCTION_PROPERTY = "cost_production";
    private static final String COST_REBUILD_PROPERTY = "cost_rebuild";
    private static final Logger LOG = LoggerFactory.getLogger(WorkplaceUsageComputer.class);
    private long startDate = 0L;
    private long endDate = 0L;
    private boolean grouping = false;
    private boolean computePast = false;

    public void setDates(long startDate, long endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        if (!GeneralizedRequest.isDateValid(this.startDate) || !GeneralizedRequest.isDateValid(this.endDate)) {
            LOG.warn("Invalid dates.");
            throw new IllegalArgumentException();
        }
        if (this.startDate >= this.endDate) {
            LOG.warn("End date must be higher than the start date.");
            throw new IllegalArgumentException();
        }
    }

    public void setGrouping(boolean grouping) {
        this.grouping = grouping;
    }

    public void setComputePast(boolean computePast) {
        this.computePast = computePast;
    }

    @Override
    public WorkplaceUsageResult compute(Superplan superplan) {
        if (this.startDate == 0L || this.endDate == 0L) {
            return null;
        }
        if (!GeneralizedRequest.isDateValid(this.startDate) || !GeneralizedRequest.isDateValid(this.endDate)) {
            return null;
        }
        if (this.startDate >= this.endDate) {
            return null;
        }
        ShopConfiguration conf = superplan.getShopConf();
        long total = this.endDate - this.startDate;
        ArrayList<WorkplaceUsageTableRow> rows = new ArrayList<WorkplaceUsageTableRow>();
        if (this.grouping) {
            LOG.debug("Computing capability islands...");
            LOG.debug("Creating rows for each island...");
            for (CapabilityIsland island : conf.getIslands()) {
                rows.add(WorkplaceUsageComputer.createIslandRow(superplan.getPlan(), island, this.startDate, this.endDate, total, this.computePast));
            }
        } else {
            LOG.debug("Creating rows for each workplace...");
            for (Workplace workplace : superplan.getShopConf().getWorkplaces()) {
                rows.add(WorkplaceUsageComputer.createWorkplaceRow(superplan.getPlan(), workplace, this.startDate, this.endDate, total, this.computePast));
            }
        }
        Collections.sort(rows);
        return new WorkplaceUsageResult(Collections.unmodifiableList(rows));
    }

    private static WorkplaceUsageTableRow createIslandRow(Plan plan, CapabilityIsland island, long startDate, long endDate, long total, boolean computePast) {
        long total2 = 0L;
        long production = 0L;
        long pastProduction = 0L;
        double productionCost = 0.0;
        long rebuild = 0L;
        long pastRebuild = 0L;
        double rebuildCost = 0.0;
        long offline = 0L;
        long waiting = 0L;
        int gors = 0;
        for (Workplace workplace : island.getWorkplaces()) {
            WorkplaceUsageTableRow row = WorkplaceUsageComputer.createWorkplaceRow(plan, workplace, startDate, endDate, total, computePast);
            total2 += total;
            production += row.getProductionTime();
            pastProduction += row.getPastProductionTime();
            productionCost += row.getProductionCost();
            rebuild += row.getRebuildTime();
            pastRebuild += row.getPastRebuildTime();
            rebuildCost += row.getRebuildCost();
            offline += row.getOfflineTime();
            waiting += row.getWaitingTime();
            gors += row.getGorCount();
        }
        return new WorkplaceUsageTableRow(island, total2, production, pastProduction, rebuild, pastRebuild, offline, waiting, gors, productionCost, rebuildCost);
    }

    private static WorkplaceUsageTableRow createWorkplaceRow(Plan plan, Workplace workplace, long startDate, long endDate, long total, boolean computePast) {
        long production = 0L;
        long pastProduction = 0L;
        long rebuild = 0L;
        long pastRebuild = 0L;
        long offline = 0L;
        long waiting = 0L;
        HashSet<GeneralizedOrderRequest> gors = new HashSet<GeneralizedOrderRequest>();
        HashSet<GeneralizedActionRequest> gars = new HashSet<GeneralizedActionRequest>();
        for (WorkplaceActivity workplaceActivity : plan.getWorkplaceSchedule(workplace).activities()) {
            long pastDuration;
            long duration = ReportUtilities.getOverlap(startDate, endDate, workplaceActivity.getStart(), workplaceActivity.getEnd());
            long l = pastDuration = workplaceActivity.getStart() < startDate ? workplaceActivity.getDuration() - duration : 0L;
            if (duration > 0L) {
                if (workplaceActivity instanceof OfflineActivity) {
                    offline += duration;
                } else if (workplaceActivity instanceof ActionActivity) {
                    production += duration;
                    gors.add(((ActionActivity)workplaceActivity).getNearestGor());
                    gars.add(((ActionActivity)workplaceActivity).getGar());
                } else if (workplaceActivity instanceof CumulativeWorkplaceActivity) {
                    production += (long)(((CumulativeWorkplaceActivity)workplaceActivity).getConsumption() * (double)duration);
                    for (ActionActivity aa : ((CumulativeWorkplaceActivity)workplaceActivity).getActionActivities()) {
                        gors.add(aa.getNearestGor());
                        gars.add(aa.getGar());
                    }
                } else if (workplaceActivity instanceof RebuildActivity) {
                    rebuild += duration;
                }
            }
            if (!computePast || pastDuration <= 0L) continue;
            if (workplaceActivity instanceof ActionActivity) {
                pastProduction += pastDuration;
                continue;
            }
            if (workplaceActivity instanceof CumulativeWorkplaceActivity) {
                pastProduction += (long)(((CumulativeWorkplaceActivity)workplaceActivity).getConsumption() * (double)pastDuration);
                continue;
            }
            if (!(workplaceActivity instanceof RebuildActivity)) continue;
            pastRebuild += pastDuration;
        }
        Map<GeneralizedActionRequest, GeneralizedActionRequest> prevGars = ReportUtilities.findPreviousGars(gars);
        for (GeneralizedActionRequest gar : gars) {
            waiting += ReportUtilities.getWaitingTime(gar, prevGars.get(gar));
        }
        double d = 1.0;
        double rebuildCostPerUnit = 1.0;
        double unitSize = 3600000.0;
        Object pc = workplace.getProperty(COST_PRODUCTION_PROPERTY);
        Object rc = workplace.getProperty(COST_REBUILD_PROPERTY);
        if (pc instanceof Number) {
            d = ((Number)pc).doubleValue();
        }
        if (rc instanceof Number) {
            rebuildCostPerUnit = ((Number)rc).doubleValue();
        }
        return new WorkplaceUsageTableRow(workplace, total, production, pastProduction, rebuild, pastRebuild, offline, waiting, gors.size(), d * ((double)production / 3600000.0), rebuildCostPerUnit * ((double)rebuild / 3600000.0));
    }
}

